#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

vector<double> th, vw, pf, vf;
double pw;
int n;

double EPS = 1e-5;

double G(double w) {
  double carry = 0.0; 
  for (int i = 0; i < n; ++i) {
    double rest = th[i] - w * vw[i];
    if (rest <= EPS) {
      continue;
    }
    carry += rest / vf[i] * pf[i];
  }
  return carry + w * pw;
}

double F() {
  double l = 0, r = 1e15;
  while (r - l > 1e-3) {
    double l_ = (2 * l + r) / 3;
    double r_ = (l + 2 * r) / 3;
    if (G(l_) < G(r_)) {
      r = r_;
    } else {
      l = l_;
    }

  // cout << l << ' ' << r << '\n'; 
  }

  
  double ans = 1e20, step = 1e-4 / 2.;
  for (double i = l; i <= r; i += step) {
    ans = min(ans, G(i));
  }
  return G((l + r) / 2.);
}

int main() {
  std::ios_base::sync_with_stdio(false);
  cout.precision(5);
  while (cin >> n && n) {
    cin >> pw;
    th.resize(n); vw.resize(n); pf.resize(n); vf.resize(n);
    double res = 1e15;
    double d_w = 1e15;
    double u_w = -1e15;
    for (int i = 0; i < n; ++i) {
      cin >> vw[i] >> pf[i] >> vf[i] >> th[i];
      if (vw[i] < 0)
        u_w = max(u_w, th[i] / vw[i]);
      else if (vw[i] > 0)
        d_w = min(d_w, th[i] / vw[i]);       
    }
    res = min(res, G(u_w));
    res = min(res, G(d_w));
    bool ok = true;
 //   res = min(res, G(0.0));
    res = min(res, F());
    cout << fixed << res << '\n';
  }
  return 0;
}